(*********************************************
TExplosion->TSprite

A simple sprite class that renders a particle
based explosive effect.
*********************************************)

unit ParticleExplosion;

interface

uses
  SysUtils, WinTypes, WinProcs, Classes, Graphics, Controls, TurboSprite;


const
  NUM_PARTICLES = 20;

type

  TExplBits = record
    pt: TPoint;
    x, y: integer;
    Speed: integer;
  end;

  TParticleExplosion = class( TSprite )
  private
    FLife: integer;
    FCol: byte;
    arParticles: array[1..NUM_PARTICLES] of TExplBits;
  protected
  public
    constructor CreateExplosion( MoveProc: TMoveProc; pt: TPoint; nLife: integer; nColor: byte );
    procedure Move; override;
    procedure Render; override;
  end;

implementation

constructor TParticleExplosion.CreateExplosion( MoveProc: TMoveProc; pt: TPoint; nLife: integer; nColor: byte );
var
  i: integer;
begin
  inherited Create( MoveProc );
  FCol := nColor;
  FLife := nLife;
  Position := pt;
  for i := 1 to NUM_PARTICLES do
  with arParticles[i] do
  begin
    pt.X := Position.X;
    pt.Y := Position.Y;
    Speed := Random( 6 ) + 1;
    x := Random( 200 );
    if Random( 100 ) > 50 then
      x := -x;
      y := Random( 200 );
    if Random( 100 ) > 50 then
      y := -y;
  end;
end;

procedure TParticleExplosion.Move;
begin
  inherited Move;
  if FLife > 0 then
  begin
    Dec( FLife );
    if FLife = 0 then
      Dead := true;
  end;
end;

procedure TParticleExplosion.Render;
var
  i: integer;
  x_, y_: integer;
begin
  inherited Render;
  for i := 1 to NUM_PARTICLES do
  with arParticles[i] do
  begin
    if Random( 200 ) > Abs( x ) then
      if x < 0 then
        Dec( pt.X, Speed )
      else
        Inc( pt.X, Speed );
    if Random( 200 ) > Abs( y ) then
      if y < 0 then
        Dec( pt.Y, Speed )
      else
        Inc( pt.Y, Speed );
    with SpriteSurface.DIBCanvas, SpriteSurface do
    begin
      PixelsClipped[pt.X - OffsetX, pt.Y - OffsetY] := Random( 16 ) + FCol;
      PixelsClipped[pt.X + 1 - OffsetX, pt.Y - OffsetY ] := Random( 16 ) + FCol;
      PixelsClipped[pt.X - OffsetX, pt.Y + 1 - OffsetY] := Random( 16 ) + FCol;
      PixelsClipped[pt.X + 1 - OffsetX, pt.Y + 1 - OffsetY] := Random( 16 ) + FCol;
    end;
  end;
end;

end.
